	function PLOT_MAG_PZ_h_FIR(wT, Mag, h, Be, D, d, opt)
 
	% 	Plots magnitude, poles & zeros, and impulse response in a single picture
	%	for an FIR filter
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 			Lars Wanhammar 2004-07-29
	% 	Modified by: 	 	LW 2004-09-22
	% 	Copyright:			by authors - not released for commercial use
	% 	Version:			1 
	% 	Known bugs:	 
	% 	Report bugs to:		Wanhammar@gmail.com
 
	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================
	hold on;

	subplot('position', [0.10 0.54 0.40 0.42])
	plot(wT, Mag,'linewidth', 2);   	% Magnitude response
	x = min(d);
	yminaxis = -(floor(log10((1+x)/x))+2)*20; % This may be changed to get a neater plot 
	axis([0 pi yminaxis 0]);
	if strcmp(opt,'mag')|strcmp(opt,'Mag')
		axis([0 pi yminaxis 0]);
		ylabel('{|\itH}({\ite^j^\omega^T})|  [dB]','FontName', fn,'FontSize',fs);
	else 
		axis([0 pi 0 -yminaxis]);
		ylabel('{|\itH}({\ite^j^\omega^T})|  [dB]','FontName', fn,'FontSize',fs);
	end 
	xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);
	set(gca,'FontName', fn,'FontSize', fs);
	ax = [0 0.2*pi 0.4*pi 0.6*pi 0.8*pi pi];
	lab = {'0';'0.2\pi';'0.4\pi';'0.6\pi';'0.8\pi';'\pi'};
	xtick(ax,lab);
	 	PLOT_FIR_SPEC(Be, D, d, opt);
	grid on;

	subplot('position', [0.56 0.54 0.42 0.42]) % Plot poles and zeros
	N = length(h)-1;
	P = zeros(N,1);		% All poles at z = 0
	Z = roots(h);
	PLOT_PZ_Z(Z, P)
	grid on;
	box on
	
%	subplot('position', [0.107 0.06 0.88 0.40])	% Plot impulse response
	subplot('position', [0.107 0.1 0.88 0.34])	% Plot impulse response
	PLOT_IMPULSE_RESPONSE_Z(h) 
	zoom on;
	hold off;
